//
//  CRPresetsWindowController.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 11/18/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRPresetsLibraryController.h"

@class CRPresetsPreviewOutlineController;

//////////////////////////////////////////////////////////////////////
// Presets window controller
//////////////////////////////////////////////////////////////////////
@interface CRPresetsWindowController : CRLibraryWindowController
{
}

@property (nonatomic, assign) IBOutlet NSPanel*			previewPanel;
@property (nonatomic, assign) IBOutlet NSImageView*		previewImage;
@property (nonatomic, assign) IBOutlet CRPresetsPreviewOutlineController* outlineController;

@property (nonatomic, assign) IBOutlet NSImageView*		zoomMinImage;
@property (nonatomic, assign) IBOutlet NSImageView*		zoomMaxImage;

@property (nonatomic, assign) IBOutlet NSToolbarItem*	loadImageItem;
@property (nonatomic, assign) IBOutlet NSToolbarItem*	batchProcessItem;
@property (nonatomic, assign) IBOutlet NSToolbarItem*	exportPresetItem;
@property (nonatomic, assign) IBOutlet NSToolbarItem*	importPresetItem;

- (CRPresetsLibraryController *)libraryController;	// override trick to 'fix' return type

- (IBAction)loadNewDocument:(id)sender;
- (IBAction)loadNewDocumentWithSelectedPreset:(id)sender;
- (IBAction)presetActionWithSegmentedControl:(id)sender;

- (IBAction)loadImage:(id)sender;
- (IBAction)toggleFullPreview:(id)sender;

- (IBAction)batchProcess:(id)sender;
- (IBAction)editPresetParameters:(id)sender;

@end